using System;
using Server;

namespace Server.Items
{
	public class DaemonSkull : Item
	{	
		[Constructable]
		public DaemonSkull() : base( 8782 + Utility.Random( 4 ) )
		{
         Weight = 3.0;
		}

		public DaemonSkull( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			
			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			
			int version = reader.ReadInt();
		}
	}
}